#! /bin/sh
#---------------------------------------------------------
# Check Channel Status
#
# Arguments:
# $1 : Queue manager name
# Read <QMGR>.mqsc from current directory
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

#------------------------------------------------------------------
# Functions for checking all channel
#
# input:
# $TARGET_QMGR:  Queue Manager Name
# ${TARGET_QMGR}.mqsc.src:  MQSC source file
#------------------------------------------------------------------
function fnCheckChannelStatus
{
  sourcefile=${TARGET_QMGR}.mqsc

  if [[ ! -f $sourcefile ]]
  then
    echo "Cannot find source file $sourcefile"
    return $RET_NG
  fi

#  for chl in `awk -F[\(\)] '$1 ~ /^[^\*]*def chl/ && $4 ~ /[sS][dD][rR]/ {print $2}' ${TARGET_QMGR}.mqsc`
  for chl in `awk -F[\(\)] '$1 ~ /^[^\*]*def chl/ {print $2}' ${TARGET_QMGR}.mqsc`
  do
    echo "mqpcf chs -qm ${TARGET_QMGR} -c $chl STATUS SECPROT SSLCERTI SSLCIPH SSLPEER"
    mqpcf chs -qm ${TARGET_QMGR} -c $chl STATUS SECPROT SSLCERTI SSLCIPH SSLPEER
    #echo $?
    echo ""
  done

  return $RET_OK
}

#-------
# Main
#-------
USAGE="usage: $0 <Qmgr>"

if (($# == 0))
then
  echo $USAGE
  exit $RET_NG
fi

TARGET_QMGR=${1}

# Check Channel Status
fnCheckChannelStatus
exit $?

