#!/bin/sh
#---------------------------------------------------------
#
# RR-2 MQI Client Bindings(Thread) (for Requester)
#
# Parameters:
# $1 : Queue manager name
# $2 : Number of connections
# $3 : Messages
# $4 : Message Bytes
# $5 : Log Directory
# $6 : Workload
# $7 : MQ Constant
# $8 : Data File
#
# Environments(./runpfmts.ini):
# $INCL_CON_TIME : Include MQCONN/MQDISC time in measurement,
#                  0:not include, 1:include
# $RCV_BUFF_SIZE : Receive buffer size
# $CON_RETRY     : The number of connection retry
# $CON_INTERVAL  : Connection retry interval
# $RR2_RequestQ  : Request queue name
# $RR2_ReplyQ    : Reply queue name
#
# History
#
# Date        Create/Update           Description
# 2022.02.21  Pulsar Integration Inc. Initial Version
#
#---------------------------------------------------------
# return code
RET_OK=0
RET_NG=1

USAGE="$0 <Qmgr> <Connections> <Messages> <Bytes> <Log Directory> <Workload> <MQ Constant> <Data File>"

if (( $# < 6 ))
then
  printf "\nUsage: $USAGE\n\n"

  cat <<-!
    RR-2 MQI Client Bindings(Thread) (for Requester)

    Parameters:
    \$1 : Queue manager name
    \$2 : Number of connections
    \$3 : Number of messages
    \$4 : Message Bytes
    \$5 : Log Directory
    \$6 : Workload
    \$7 : MQ Constant (ex. MQPER_PERSISTENT, MQPER_NOT_PERSISTENT)
    \$8 : Data File (Input message file) (Option)
         If not specified, "<workload name>" is used as the message.

    Environments(./runpfmts.ini):
    \$INCL_CON_TIME : Include MQCONN/MQDISC time in measurement,
                     0:not include, 1:include
    \$RCV_BUFF_SIZE : Receive buffer size
    \$CON_RETRY     : The number of connection retry
    \$CON_INTERVAL  : Connection retry interval
    \$RR2_RequestQ  : Request queue name
    \$RR2_ReplyQ    : Reply queue name

!

  exit $RET_NG
fi

# source environments for performance test
. ./runpfmts.ini

# import library
. ./lib/libpfmts.sh

TARGET_QMGR=$1
Connections=$2
Messages=$3
Bytes=$4
LogDirPre=$5
Workload=$6
MQ_Constant=$7
DataFile=$8

TRM=""
if [[ $INCL_CON_TIME -eq "1" ]]
then
    TRM="-tr"
fi

LogDir=$LogDirPre/${Workload}_${Bytes}_${Connections}_${TARGET_QMGR}_`date "+%Y%m%d_%H%M%S"`

mkdir -p $LogDir

LogNamePre=$LogDir/req
logName=${LogNamePre}_`date "+%Y%m%d_%H%M%S"`.log

((Total_Messages = Connections * Messages))

echo "Start Requester Program, Put $RR2_RequestQ, Get $RR2_ReplyQ"
# Requester
# secondary side: MQGMO_ACCEPT_TRUNCATED_MSG
if [[ -z $DataFile ]]
then
  ArgumentListReq="-qm $TARGET_QMGR -q $RR2_RequestQ -x $CONNAME -ch $CHANNEL -m $Workload -iq $RR2_ReplyQ -rq $RR2_ReplyQ MQMT_REQUEST $MQ_CONSTANT MQPMO_NO_SYNCPOINT -ni $Connections -n $Messages -l $Bytes -cr $CON_RETRY -wp $CON_INTERVAL $TRM -ss -sz $RCV_BUFF_SIZE MQGMO_WAIT MQWI_UNLIMITED MQGMO_NO_SYNCPOINT MQGMO_ACCEPT_TRUNCATED_MSG -mc"
else
  ArgumentListReq="-qm $TARGET_QMGR -q $RR2_RequestQ -x $CONNAME -ch $CHANNEL -f $DataFile -iq $RR2_ReplyQ -rq $RR2_ReplyQ MQMT_REQUEST $MQ_CONSTANT MQPMO_NO_SYNCPOINT -ni $Connections -n $Messages -l $Bytes -cr $CON_RETRY -wp $CON_INTERVAL $TRM -ss -sz $RCV_BUFF_SIZE MQGMO_WAIT MQWI_UNLIMITED MQGMO_NO_SYNCPOINT MQGMO_ACCEPT_TRUNCATED_MSG -mc"
fi

  echo "mqpgfc $ArgumentListReq"
  nohup mqpgfc $ArgumentListReq 2>&1 | tee $logName > /dev/null &

flag=0
while :
do
  ps -ef|grep -E "mqpgfc.*$TARGET_QMGR.*$RR2_RequestQ.*$RR2_ReplyQ|tee.*$logName"|grep -v grep > /dev/null

  if (( $? == 1 ))
  then
    printf "terminated."
    break
  fi
  sleep 1
  if ((flag == 0))
  then
    printf "Waiting for the completion of the test process."
  else
    printf "."
  fi
  ((flag += 1))
done

echo ""

fnGetElapsedTime_Thread $logName $Total_Messages | tee -a $LogDirPre/console.log

exit $RET_OK

